<?php
// public/admin_china_list.php
session_start();
require_once __DIR__ . '/../config/db.php';

$pdo = get_pdo();

$stmt = $pdo->query("
    SELECT a.id, a.status, a.country, a.current_step, a.created_at,
           ap.given_name, ap.family_name, ap.phone, ap.email,
           v.center, v.appointment_date, v.time_slot, v.payment_status
    FROM visa_applications a
    LEFT JOIN visa_applicants ap    ON ap.application_id = a.id
    LEFT JOIN visa_appointments v   ON v.application_id = a.id
    WHERE a.country = 'china'
    ORDER BY a.id DESC
");
$rows = $stmt->fetchAll();

function e($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لیست درخواست‌های ویزای چین (ادمین)</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family:sans-serif; background:#f5f7fb; margin:0; padding:0; }
        .container {
            max-width:1100px; margin:40px auto; background:#fff;
            border-radius:12px; padding:24px 28px;
            box-shadow:0 6px 18px rgba(0,0,0,0.08);
        }
        h1 { font-size:20px; margin-bottom:10px; }
        table {
            width:100%; border-collapse:collapse; font-size:12px;
        }
        th, td {
            padding:6px 8px; border-bottom:1px solid #e5e8f0;
            text-align:right;
        }
        th { background:#f1f3fb; font-weight:bold; }
        .status-pill {
            display:inline-block; padding:2px 6px; border-radius:999px;
            font-size:10px;
        }
        .st-draft { background:#fff4e5; color:#b25b00; border:1px solid #f0c78a; }
        .st-submitted { background:#e6f1ff; color:#1347b0; border:1px solid #aac5ff; }
        .st-booked { background:#e6ffed; color:#146c2e; border:1px solid #9be7b0; }
        a.view-link {
            font-size:11px; color:#3563e9; text-decoration:none;
        }
        a.view-link:hover { text-decoration:underline; }
        .badge { font-size:11px; color:#777; margin-bottom:10px; display:block; }
    </style>
</head>
<body>
<div class="container">
    <h1>لیست درخواست‌های ویزای چین</h1>
    <span class="badge">این صفحه صرفاً برای استفاده داخلی ادمین است. (باید پشت لاگین/اچ‌تی‌اکسس قرار بگیرد.)</span>

    <table>
        <thead>
        <tr>
            <th>#</th>
            <th>نام متقاضی</th>
            <th>موبایل</th>
            <th>ایمیل</th>
            <th>وضعیت پرونده</th>
            <th>مرکز</th>
            <th>تاریخ نوبت</th>
            <th>بازه زمانی</th>
            <th>پرداخت</th>
            <th>مرحله</th>
            <th>جزئیات</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($rows as $r): ?>
            <tr>
                <td><?= e($r['id']) ?></td>
                <td><?= e(trim($r['given_name'].' '.$r['family_name'])) ?></td>
                <td><?= e($r['phone']) ?></td>
                <td><?= e($r['email']) ?></td>
                <td>
                    <?php
                    $status = $r['status'];
                    $cls = 'st-draft'; $txt = 'Draft';
                    if ($status === 'submitted') { $cls = 'st-submitted'; $txt = 'Submitted'; }
                    if ($status === 'appointment_booked') { $cls = 'st-booked'; $txt = 'Appointment Booked'; }
                    ?>
                    <span class="status-pill <?= $cls ?>"><?= e($txt) ?></span>
                </td>
                <td><?= e($r['center'] ?: '-') ?></td>
                <td><?= e($r['appointment_date'] ?: '-') ?></td>
                <td><?= e($r['time_slot'] ?: '-') ?></td>
                <td><?= e($r['payment_status'] ?: '-') ?></td>
                <td><?= e($r['current_step']) ?></td>
                <td>
                    <a class="view-link" href="admin_china_view.php?id=<?= e($r['id']) ?>">مشاهده</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
