<?php
// public/admin_china_view.php
session_start();
require_once __DIR__ . '/../config/db.php';

if (empty($_GET['id']) || !ctype_digit($_GET['id'])) {
    die('Invalid ID');
}
$appId = (int)$_GET['id'];

$pdo = get_pdo();

// درخواست
$stmt = $pdo->prepare("SELECT * FROM visa_applications WHERE id = ? AND country = 'china'");
$stmt->execute([$appId]);
$app = $stmt->fetch();
if (!$app) {
    die('Application not found.');
}

// متقاضی
$stmt = $pdo->prepare("SELECT * FROM visa_applicants WHERE application_id = ?");
$stmt->execute([$appId]);
$applicant = $stmt->fetch();

// پاسپورت
$stmt = $pdo->prepare("SELECT * FROM visa_passports WHERE application_id = ?");
$stmt->execute([$appId]);
$passport = $stmt->fetch();

// سفر
$stmt = $pdo->prepare("SELECT * FROM visa_travels WHERE application_id = ?");
$stmt->execute([$appId]);
$travel = $stmt->fetch();

// مدارک
$stmt = $pdo->prepare("SELECT * FROM visa_documents WHERE application_id = ? ORDER BY doc_type");
$stmt->execute([$appId]);
$docs = $stmt->fetchAll();

// نوبت
$stmt = $pdo->prepare("SELECT * FROM visa_appointments WHERE application_id = ?");
$stmt->execute([$appId]);
$appointment = $stmt->fetch();

function e($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>جزئیات درخواست چین #<?= e($appId) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family:sans-serif; background:#f5f7fb; margin:0; padding:0; }
        .container {
            max-width:960px; margin:40px auto; background:#fff;
            border-radius:12px; padding:24px 28px;
            box-shadow:0 6px 18px rgba(0,0,0,0.08);
        }
        h1 { font-size:20px; margin-bottom:10px; }
        .section {
            border:1px solid #e0e4ef; border-radius:10px;
            padding:14px 16px; margin-bottom:16px; background:#fafbff;
        }
        .section h2 { margin:0 0 8px 0; font-size:16px; }
        table { width:100%; border-collapse:collapse; font-size:12px; }
        td { padding:4px 6px; border-bottom:1px solid #e5e8f0; }
        td.label { width:26%; font-weight:bold; color:#333; }
        .doc-list { list-style:none; padding:0; margin:0; font-size:12px; }
        .doc-list li { padding:4px 0; border-bottom:1px dashed #dde2f0; }
        .badge { font-size:11px; color:#777; margin-bottom:10px; display:block; }
        a.back-link { font-size:12px; text-decoration:none; color:#3563e9; }
    </style>
</head>
<body>

<div class="container">
    <h1>جزئیات درخواست ویزای چین #<?= e($appId) ?></h1>
    <span class="badge"><a href="admin_china_list.php" class="back-link">← بازگشت به لیست</a></span>

    <div class="section">
        <h2>وضعیت پرونده</h2>
        <table>
            <tr>
                <td class="label">وضعیت</td>
                <td><?= e($app['status']) ?></td>
            </tr>
            <tr>
                <td class="label">مرحله فعلی</td>
                <td><?= e($app['current_step']) ?></td>
            </tr>
            <tr>
                <td class="label">تاریخ ایجاد</td>
                <td><?= e($app['created_at']) ?></td>
            </tr>
            <tr>
                <td class="label">آخرین بروزرسانی</td>
                <td><?= e($app['updated_at']) ?></td>
            </tr>
        </table>
    </div>

    <div class="section">
        <h2>مشخصات متقاضی</h2>
        <?php if ($applicant): ?>
            <table>
                <tr><td class="label">نام لاتین</td><td><?= e($applicant['given_name'].' '.$applicant['family_name']) ?></td></tr>
                <tr><td class="label">جنسیت</td><td><?= e($applicant['gender']) ?></td></tr>
                <tr><td class="label">تاریخ تولد</td><td><?= e($applicant['dob']) ?></td></tr>
                <tr><td class="label">ملیت</td><td><?= e($applicant['nationality']) ?></td></tr>
                <tr><td class="label">کشور محل تولد</td><td><?= e($applicant['birth_country']) ?></td></tr>
                <tr><td class="label">وضعیت تأهل</td><td><?= e($applicant['marital_status']) ?></td></tr>
                <tr><td class="label">موبایل</td><td><?= e($applicant['phone']) ?></td></tr>
                <tr><td class="label">ایمیل</td><td><?= e($applicant['email']) ?></td></tr>
            </table>
        <?php else: ?>
            <p>اطلاعات متقاضی یافت نشد.</p>
        <?php endif; ?>
    </div>

    <div class="section">
        <h2>پاسپورت</h2>
        <?php if ($passport): ?>
            <table>
                <tr><td class="label">شماره پاسپورت</td><td><?= e($passport['passport_number']) ?></td></tr>
                <tr><td class="label">محل صدور</td><td><?= e($passport['place_of_issue']) ?></td></tr>
                <tr><td class="label">تاریخ صدور</td><td><?= e($passport['date_of_issue']) ?></td></tr>
                <tr><td class="label">تاریخ انقضا</td><td><?= e($passport['date_of_expiry']) ?></td></tr>
            </table>
        <?php else: ?>
            <p>اطلاعات پاسپورت ثبت نشده.</p>
        <?php endif; ?>
    </div>

    <div class="section">
        <h2>سفر</h2>
        <?php if ($travel): ?>
            <table>
                <tr><td class="label">نوع ویزا</td><td><?= e($travel['visa_type']) ?></td></tr>
                <tr><td class="label">هدف سفر</td><td><?= e($travel['purpose_of_visit']) ?></td></tr>
                <tr><td class="label">تاریخ ورود</td><td><?= e($travel['entry_date']) ?></td></tr>
                <tr><td class="label">تاریخ خروج</td><td><?= e($travel['exit_date']) ?></td></tr>
                <tr><td class="label">مدت اقامت</td><td><?= e($travel['duration_days']) ?> روز</td></tr>
                <tr><td class="label">اولین شهر/فرودگاه</td><td><?= e($travel['port_of_entry']) ?></td></tr>
                <tr><td class="label">سفر قبلی به چین</td><td><?= $travel['previous_china_visit'] ? 'بله' : 'خیر' ?></td></tr>
                <?php if ($travel['previous_china_visit'] && !empty($travel['previous_visa_details'])): ?>
                    <tr><td class="label">جزئیات سفر قبلی</td><td><?= nl2br(e($travel['previous_visa_details'])) ?></td></tr>
                <?php endif; ?>
            </table>
        <?php else: ?>
            <p>اطلاعات سفر ثبت نشده.</p>
        <?php endif; ?>
    </div>

    <div class="section">
        <h2>مدارک</h2>
        <?php if ($docs): ?>
            <ul class="doc-list">
                <?php foreach ($docs as $d): ?>
                    <li>
                        نوع: <strong><?= e($d['doc_type']) ?></strong> —
                        فایل: <em><?= e($d['original_name']) ?></em>
                        (<?= e($d['mime_type']) ?>)
                        <!-- اینجا اگر خواستی لینک دانلود مستقیم از uploads/china هم می‌تونی بسازی -->
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <p>مدرکی آپلود نشده.</p>
        <?php endif; ?>
    </div>

    <div class="section">
        <h2>نوبت و پرداخت</h2>
        <?php if ($appointment): ?>
            <table>
                <tr><td class="label">مرکز</td><td><?= e($appointment['center']) ?></td></tr>
                <tr><td class="label">تاریخ نوبت</td><td><?= e($appointment['appointment_date']) ?></td></tr>
                <tr><td class="label">بازه زمانی</td><td><?= e($appointment['time_slot']) ?></td></tr>
                <tr><td class="label">روش پرداخت</td><td><?= e($appointment['payment_method']) ?></td></tr>
                <tr><td class="label">وضعیت پرداخت</td><td><?= e($appointment['payment_status']) ?></td></tr>
                <tr><td class="label">کد پیگیری پرداخت</td><td><?= e($appointment['payment_ref'] ?: '-') ?></td></tr>
            </table>
        <?php else: ?>
            <p>نوبتی برای این پرونده ثبت نشده.</p>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
