<?php
// public/china_step2.php
session_start();

// اگر هنوز application ساخته نشده، برگرد به مرحله ۱
if (empty($_SESSION['china_application_id'])) {
    header('Location: china_step1.php');
    exit;
}

// CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// خطاها و old از سشن
$errors = $_SESSION['form_errors'] ?? [];
$old    = $_SESSION['form_old'] ?? [];
unset($_SESSION['form_errors'], $_SESSION['form_old']);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مرحله ۲ - اطلاعات پاسپورت ویزای چین</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: sans-serif; background: #f5f7fb; margin:0; padding:0;}
        .container {
            max-width: 720px; margin:40px auto; background:#fff;
            border-radius:12px; padding:24px 28px;
            box-shadow:0 6px 18px rgba(0,0,0,0.08);
        }
        h1 { font-size:22px; margin-bottom:6px; text-align:right;}
        .subtitle { font-size:13px; color:#666; margin-bottom:20px; text-align:right;}
        .badge-country {
            display:inline-block; background:#eaf1ff; color:#1b46c2;
            padding:4px 10px; border-radius:999px; font-size:11px; margin-bottom:10px;
        }
        .form-row { display:flex; flex-wrap:wrap; gap:16px;}
        .form-group { flex:1 1 48%; display:flex; flex-direction:column; margin-bottom:14px;}
        label { font-size:13px; margin-bottom:4px; color:#333;}
        label span.en { font-size:11px; color:#777;}
        input[type="text"], input[type="date"] {
            padding:8px 10px; font-size:13px; border:1px solid #ccd2e0;
            border-radius:6px; outline:none; direction:ltr;
        }
        input:focus {
            border-color:#3563e9; box-shadow:0 0 0 2px rgba(53,99,233,0.15);
        }
        .error { color:#d93025; font-size:11px; margin-top:3px;}
        .global-error {
            background:#ffe5e5; border:1px solid #f5b5b5; color:#a30000;
            padding:10px 12px; border-radius:8px; font-size:12px; margin-bottom:14px;
        }
        .helper { font-size:11px; color:#888; margin-top:2px;}
        .btn-row { display:flex; justify-content:space-between; margin-top:18px;}
        button { border:none; padding:9px 18px; border-radius:8px; font-size:13px; cursor:pointer;}
        .btn-back { background:#e0e4ef; color:#333;}
        .btn-next { background:#3563e9; color:#fff;}
        .btn-next:hover { background:#2749b4;}
        @media (max-width:600px){
            .form-group { flex:1 1 100%; }
            .container { margin:16px; padding:18px; }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="badge-country">🇨🇳 فرم ویزای چین - مرحله ۲ از ۶</div>
    <h1>اطلاعات پاسپورت</h1>
    <div class="subtitle">
        اطلاعات زیر را دقیقاً مطابق پاسپورت انگلیسی وارد کنید.
    </div>

    <?php if (!empty($errors)): ?>
        <div class="global-error">
            لطفاً خطاهای مشخص‌شده در فرم را اصلاح کنید.
        </div>
    <?php endif; ?>

    <form method="post" action="china_step2_submit.php" novalidate>
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">

        <div class="form-row">
            <div class="form-group">
                <label>
                    شماره پاسپورت
                    <span class="en">Passport Number</span>
                </label>
                <input type="text" name="passport_number"
                       value="<?= htmlspecialchars($old['passport_number'] ?? '') ?>"
                       placeholder="P12345678">
                <?php if (!empty($errors['passport_number'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['passport_number']) ?></div>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label>
                    محل صدور پاسپورت
                    <span class="en">Place of Issue</span>
                </label>
                <input type="text" name="place_of_issue"
                       value="<?= htmlspecialchars($old['place_of_issue'] ?? '') ?>"
                       placeholder="TEHRAN">
                <?php if (!empty($errors['place_of_issue'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['place_of_issue']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label>
                    تاریخ صدور پاسپورت
                    <span class="en">Date of Issue</span>
                </label>
                <input type="date" name="date_of_issue"
                       value="<?= htmlspecialchars($old['date_of_issue'] ?? '') ?>">
                <?php if (!empty($errors['date_of_issue'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['date_of_issue']) ?></div>
                <?php endif; ?>
                <div class="helper">فرمت: YYYY-MM-DD</div>
            </div>

            <div class="form-group">
                <label>
                    تاریخ انقضای پاسپورت
                    <span class="en">Date of Expiry</span>
                </label>
                <input type="date" name="date_of_expiry"
                       value="<?= htmlspecialchars($old['date_of_expiry'] ?? '') ?>">
                <?php if (!empty($errors['date_of_expiry'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['date_of_expiry']) ?></div>
                <?php endif; ?>
                <div class="helper">باید حداقل ۶ ماه از تاریخ سفر اعتبار داشته باشد.</div>
            </div>
        </div>

        <div class="btn-row">
            <a href="china_step1.php">
                <button type="button" class="btn-back">← بازگشت به مرحله قبل</button>
            </a>
            <button type="submit" class="btn-next">ذخیره و ادامه به مرحله بعد (اطلاعات سفر)</button>
        </div>
    </form>
</div>

</body>
</html>
