<?php
// public/china_step3.php
session_start();

// اگر هنوز application نداریم → برگرد مرحله ۱
if (empty($_SESSION['china_application_id'])) {
    header('Location: china_step1.php');
    exit;
}

// CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// خطاها و old از سشن
$errors = $_SESSION['form_errors'] ?? [];
$old    = $_SESSION['form_old'] ?? [];
unset($_SESSION['form_errors'], $_SESSION['form_old']);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مرحله ۳ - اطلاعات سفر ویزای چین</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family:sans-serif; background:#f5f7fb; margin:0; padding:0;}
        .container {
            max-width: 720px; margin:40px auto; background:#fff;
            border-radius:12px; padding:24px 28px;
            box-shadow:0 6px 18px rgba(0,0,0,0.08);
        }
        h1 { font-size:22px; margin-bottom:6px; text-align:right; }
        .subtitle { font-size:13px; color:#666; margin-bottom:20px; text-align:right; }
        .badge-country {
            display:inline-block; background:#eaf1ff; color:#1b46c2;
            padding:4px 10px; border-radius:999px; font-size:11px; margin-bottom:10px;
        }
        .form-row { display:flex; flex-wrap:wrap; gap:16px; }
        .form-group { flex:1 1 48%; display:flex; flex-direction:column; margin-bottom:14px; }
        .form-group.full { flex:1 1 100%; }
        label { font-size:13px; margin-bottom:4px; color:#333; }
        label span.en { font-size:11px; color:#777; }
        input[type="text"], input[type="number"], input[type="date"], select, textarea {
            padding:8px 10px; font-size:13px; border:1px solid #ccd2e0;
            border-radius:6px; outline:none; direction:ltr;
        }
        textarea { min-height:70px; resize:vertical; }
        input:focus, select:focus, textarea:focus {
            border-color:#3563e9; box-shadow:0 0 0 2px rgba(53,99,233,0.15);
        }
        .error { color:#d93025; font-size:11px; margin-top:3px; }
        .global-error {
            background:#ffe5e5; border:1px solid #f5b5b5; color:#a30000;
            padding:10px 12px; border-radius:8px; font-size:12px; margin-bottom:14px;
        }
        .helper { font-size:11px; color:#888; margin-top:2px; }
        .btn-row { display:flex; justify-content:space-between; margin-top:18px; }
        button { border:none; padding:9px 18px; border-radius:8px; font-size:13px; cursor:pointer;}
        .btn-back { background:#e0e4ef; color:#333; }
        .btn-next { background:#3563e9; color:#fff; }
        .btn-next:hover { background:#2749b4; }
        @media (max-width:600px){
            .form-group { flex:1 1 100%; }
            .container { margin:16px; padding:18px; }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="badge-country">🇨🇳 فرم ویزای چین - مرحله ۳ از ۶</div>
    <h1>اطلاعات سفر</h1>
    <div class="subtitle">
        لطفاً جزئیات سفر خود به چین را وارد کنید. این اطلاعات باید با بلیط و رزرو هتل شما هم‌خوانی داشته باشد.
    </div>

    <?php if (!empty($errors)): ?>
        <div class="global-error">
            لطفاً خطاهای مشخص‌شده در فرم را اصلاح کنید.
        </div>
    <?php endif; ?>

    <form method="post" action="china_step3_submit.php" novalidate>
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">

        <div class="form-row">
            <div class="form-group">
                <label>
                    نوع ویزا
                    <span class="en">Visa Type</span>
                </label>
                <select name="visa_type">
                    <option value="">انتخاب کنید</option>
                    <option value="tourist"  <?= (isset($old['visa_type']) && $old['visa_type']==='tourist')  ? 'selected' : '' ?>>Tourist (L)</option>
                    <option value="business" <?= (isset($old['visa_type']) && $old['visa_type']==='business') ? 'selected' : '' ?>>Business (M)</option>
                    <option value="family"   <?= (isset($old['visa_type']) && $old['visa_type']==='family')   ? 'selected' : '' ?>>Family Visit (Q)</option>
                    <option value="transit"  <?= (isset($old['visa_type']) && $old['visa_type']==='transit')  ? 'selected' : '' ?>>Transit (G)</option>
                </select>
                <?php if (!empty($errors['visa_type'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['visa_type']) ?></div>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label>
                    هدف سفر (کوتاه)
                    <span class="en">Purpose of Visit</span>
                </label>
                <input type="text" name="purpose_of_visit"
                       value="<?= htmlspecialchars($old['purpose_of_visit'] ?? '') ?>"
                       placeholder="Tourism / Business Meeting / Family Visit">
                <?php if (!empty($errors['purpose_of_visit'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['purpose_of_visit']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label>
                    تاریخ ورود به چین
                    <span class="en">Entry Date</span>
                </label>
                <input type="date" name="entry_date"
                       value="<?= htmlspecialchars($old['entry_date'] ?? '') ?>">
                <?php if (!empty($errors['entry_date'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['entry_date']) ?></div>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label>
                    تاریخ خروج از چین
                    <span class="en">Exit Date</span>
                </label>
                <input type="date" name="exit_date"
                       value="<?= htmlspecialchars($old['exit_date'] ?? '') ?>">
                <?php if (!empty($errors['exit_date'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['exit_date']) ?></div>
                <?php endif; ?>
                <div class="helper">باید بعد از تاریخ ورود باشد.</div>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label>
                    مدت اقامت (به روز)
                    <span class="en">Duration of Stay (days)</span>
                </label>
                <input type="number" name="duration_days"
                       value="<?= htmlspecialchars($old['duration_days'] ?? '') ?>"
                       min="1" max="90" step="1">
                <?php if (!empty($errors['duration_days'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['duration_days']) ?></div>
                <?php endif; ?>
                <div class="helper">بر اساس بلیط و رزرو هتل محاسبه کنید.</div>
            </div>

            <div class="form-group">
                <label>
                    اولین شهر / فرودگاه ورود
                    <span class="en">Port of Entry</span>
                </label>
                <input type="text" name="port_of_entry"
                       value="<?= htmlspecialchars($old['port_of_entry'] ?? '') ?>"
                       placeholder="Beijing / Shanghai">
                <?php if (!empty($errors['port_of_entry'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['port_of_entry']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group full">
                <label>
                    آیا قبلاً به چین سفر کرده‌اید؟
                    <span class="en">Previous Travel to China</span>
                </label>
                <select name="previous_china_visit">
                    <option value="0" <?= (isset($old['previous_china_visit']) && $old['previous_china_visit']=='0') ? 'selected' : '' ?>>خیر</option>
                    <option value="1" <?= (isset($old['previous_china_visit']) && $old['previous_china_visit']=='1') ? 'selected' : '' ?>>بله</option>
                </select>
                <div class="helper">در صورت انتخاب «بله»، اطلاعات ویزا/سفر قبلی را در کادر زیر وارد کنید.</div>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group full">
                <label>
                    توضیحات سفر/ویزای قبلی (در صورت وجود)
                    <span class="en">Previous Visa / Travel Details</span>
                </label>
                <textarea name="previous_visa_details"
                          placeholder="Year, city, visa type, purpose..."><?= htmlspecialchars($old['previous_visa_details'] ?? '') ?></textarea>
                <?php if (!empty($errors['previous_visa_details'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['previous_visa_details']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="btn-row">
            <a href="china_step2.php">
                <button type="button" class="btn-back">← بازگشت به مرحله قبل</button>
            </a>
            <button type="submit" class="btn-next">ذخیره و ادامه به مرحله بعد (آپلود مدارک)</button>
        </div>
    </form>
</div>

</body>
</html>
