<?php
// public/china_step3_submit.php
session_start();
require_once __DIR__ . '/../config/db.php';

// اگر هنوز application نداریم → برگرد
if (empty($_SESSION['china_application_id'])) {
    header('Location: china_step1.php');
    exit;
}

// CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token'] ?? '')) {
    die('Invalid CSRF token');
}

$errors = [];
$old    = [];

$fields = [
    'visa_type','purpose_of_visit','entry_date','exit_date',
    'duration_days','port_of_entry','previous_china_visit','previous_visa_details'
];

foreach ($fields as $f) {
    $old[$f] = isset($_POST[$f]) ? trim($_POST[$f]) : '';
}

// اعتبارسنجی
if (!in_array($old['visa_type'], ['tourist','business','family','transit'], true)) {
    $errors['visa_type'] = 'نوع ویزا را انتخاب کنید.';
}

if ($old['purpose_of_visit'] === '' || mb_strlen($old['purpose_of_visit']) < 3) {
    $errors['purpose_of_visit'] = 'هدف سفر را به صورت کوتاه وارد کنید.';
}

// تاریخ‌ها
$entry = DateTime::createFromFormat('Y-m-d', $old['entry_date']);
$entryErr = DateTime::getLastErrors();
if ($entry === false || $entryErr['warning_count'] > 0 || $entryErr['error_count'] > 0) {
    $errors['entry_date'] = 'تاریخ ورود نامعتبر است.';
}

$exit = DateTime::createFromFormat('Y-m-d', $old['exit_date']);
$exitErr = DateTime::getLastErrors();
if ($exit === false || $exitErr['warning_count'] > 0 || $exitErr['error_count'] > 0) {
    $errors['exit_date'] = 'تاریخ خروج نامعتبر است.';
}

if (empty($errors['entry_date']) && empty($errors['exit_date'])) {
    if ($exit <= $entry) {
        $errors['exit_date'] = 'تاریخ خروج باید بعد از تاریخ ورود باشد.';
    }
}

// مدت اقامت
if ($old['duration_days'] === '' || !ctype_digit($old['duration_days'])) {
    $errors['duration_days'] = 'مدت اقامت را به عدد وارد کنید.';
} else {
    $days = (int)$old['duration_days'];
    if ($days < 1 || $days > 90) {
        $errors['duration_days'] = 'مدت اقامت باید بین ۱ تا ۹۰ روز باشد.';
    }
}

// فرودگاه / شهر ورود
if ($old['port_of_entry'] === '' || !preg_match('/^[A-Za-z\s]{2,}$/', $old['port_of_entry'])) {
    $errors['port_of_entry'] = 'نام شهر/فرودگاه ورود را به صورت لاتین وارد کنید.';
}

// سفر قبلی
if ($old['previous_china_visit'] !== '0' && $old['previous_china_visit'] !== '1') {
    $errors['previous_china_visit'] = 'گزینه سفر قبلی به چین را مشخص کنید.';
}
if ($old['previous_china_visit'] === '1' && $old['previous_visa_details'] === '') {
    $errors['previous_visa_details'] = 'لطفاً جزئیات ویزا یا سفر قبلی را وارد کنید.';
}

// اگر خطا هست:
if ($errors) {
    $_SESSION['form_errors'] = $errors;
    $_SESSION['form_old']    = $old;
    header('Location: china_step3.php');
    exit;
}

// ذخیره در دیتابیس
$pdo = get_pdo();
$applicationId = $_SESSION['china_application_id'];

$pdo->beginTransaction();

try {
    // آیا رکوردی برای این application وجود دارد؟
    $stmt = $pdo->prepare("SELECT id FROM visa_travels WHERE application_id = ?");
    $stmt->execute([$applicationId]);
    $existingId = $stmt->fetchColumn();

    if ($existingId) {
        $stmt = $pdo->prepare("
            UPDATE visa_travels
            SET visa_type = ?, purpose_of_visit = ?, duration_days = ?, port_of_entry = ?,
                entry_date = ?, exit_date = ?, previous_china_visit = ?, previous_visa_details = ?, 
                updated_at = NOW()
            WHERE application_id = ?
        ");
        $stmt->execute([
            $old['visa_type'],
            $old['purpose_of_visit'],
            (int)$old['duration_days'],
            $old['port_of_entry'],
            $old['entry_date'],
            $old['exit_date'],
            (int)$old['previous_china_visit'],
            $old['previous_visa_details'] ?: null,
            $applicationId
        ]);
    } else {
        $stmt = $pdo->prepare("
            INSERT INTO visa_travels
                (application_id, visa_type, purpose_of_visit, duration_days, port_of_entry,
                 entry_date, exit_date, previous_china_visit, previous_visa_details,
                 created_at, updated_at)
            VALUES (?,?,?,?,?,?,?,?,?,NOW(),NOW())
        ");
        $stmt->execute([
            $applicationId,
            $old['visa_type'],
            $old['purpose_of_visit'],
            (int)$old['duration_days'],
            $old['port_of_entry'],
            $old['entry_date'],
            $old['exit_date'],
            (int)$old['previous_china_visit'],
            $old['previous_visa_details'] ?: null,
        ]);
    }

    // آپدیت مرحله
    $stmt = $pdo->prepare("UPDATE visa_applications SET current_step = 3, updated_at = NOW() WHERE id = ?");
    $stmt->execute([$applicationId]);

    $pdo->commit();
} catch (Exception $e) {
    $pdo->rollBack();
    die('Database error: ' . $e->getMessage());
}

// فعلاً برای تست:
header('Location: china_step4.php'); // بعداً می‌کنیم china_step4.php (آپلود مدارک)
exit;
