<?php
// public/china_step4.php
session_start();

if (empty($_SESSION['china_application_id'])) {
    header('Location: china_step1.php');
    exit;
}

// CSRF
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$errors  = $_SESSION['form_errors'] ?? [];
$success = $_SESSION['success_message'] ?? null;

unset($_SESSION['form_errors'], $_SESSION['success_message']);



?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مرحله ۴ - آپلود مدارک ویزای چین</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family:sans-serif; background:#f5f7fb; margin:0; padding:0;}
        .container {
            max-width: 720px; margin:40px auto; background:#fff;
            border-radius:12px; padding:24px 28px;
            box-shadow:0 6px 18px rgba(0,0,0,0.08);
        }
        h1 { font-size:22px; margin-bottom:6px; text-align:right;}
        .subtitle { font-size:13px; color:#666; margin-bottom:20px; text-align:right;}
        .badge-country {
            display:inline-block; background:#eaf1ff; color:#1b46c2;
            padding:4px 10px; border-radius:999px; font-size:11px; margin-bottom:10px;
        }
        .doc-group {
            margin-bottom:18px; padding:12px 14px;
            border-radius:8px; border:1px solid #e0e4ef;
            background:#f9fbff;
        }
        .doc-group h3 {
            margin:0 0 6px 0; font-size:14px; display:flex;
            justify-content:space-between; align-items:center;
        }
        .doc-group small { font-size:11px; color:#777; }
        input[type="file"] {
            margin-top:6px;
        }
        .error { color:#d93025; font-size:11px; margin-top:3px;}
        .global-error {
            background:#ffe5e5; border:1px solid #f5b5b5; color:#a30000;
            padding:10px 12px; border-radius:8px; font-size:12px; margin-bottom:14px;
        }
        .helper { font-size:11px; color:#888; margin-top:4px;}
        .btn-row { display:flex; justify-content:space-between; margin-top:18px;}
        button { border:none; padding:9px 18px; border-radius:8px; font-size:13px; cursor:pointer;}
        .btn-back { background:#e0e4ef; color:#333;}
        .btn-next { background:#3563e9; color:#fff;}
        .btn-next:hover { background:#2749b4;}
        @media (max-width:600px){
            .container { margin:16px; padding:18px; }
        }

        .global-success {
    background:#e6ffed;
    border:1px solid #9be7b0;
    color:#146c2e;
    padding:10px 12px;
    border-radius:8px;
    font-size:12px;
    margin-bottom:14px;
}

    </style>
</head>
<body>

<?php if ($success): ?>
    <div class="global-success">
        <?= htmlspecialchars($success) ?>
    </div>
<?php endif; ?>


<div class="container">
    <div class="badge-country">🇨🇳 فرم ویزای چین - مرحله ۴ از ۶</div>
    <h1>آپلود مدارک</h1>
    <div class="subtitle">
        لطفاً مدارک زیر را به صورت فایل واضح و خوانا بارگذاری کنید. حداکثر حجم هر فایل ۲ مگابایت باشد.
    </div>

    <?php if (!empty($errors)): ?>
        <div class="global-error">
            لطفاً خطاهای مشخص‌شده در مدارک را اصلاح کنید.
        </div>
    <?php endif; ?>

    <form method="post" action="china_step4_submit.php" enctype="multipart/form-data" novalidate>
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">

        <!-- پاسپورت -->
        <div class="doc-group">
            <h3>
                اسکن صفحه اول پاسپورت
                <small>الزامی</small>
            </h3>
            <input type="file" name="passport" accept=".jpg,.jpeg,.png,.pdf">
            <?php if (!empty($errors['passport'])): ?>
                <div class="error"><?= htmlspecialchars($errors['passport']) ?></div>
            <?php endif; ?>
            <div class="helper">فرمت مجاز: JPG / PNG / PDF – تصویر روشن و کامل بدون برش.</div>
        </div>

        <!-- عکس پرسنلی -->
        <div class="doc-group">
            <h3>
                عکس پرسنلی ۴×۶
                <small>الزامی</small>
            </h3>
            <input type="file" name="photo" accept=".jpg,.jpeg,.png">
            <?php if (!empty($errors['photo'])): ?>
                <div class="error"><?= htmlspecialchars($errors['photo']) ?></div>
            <?php endif; ?>
            <div class="helper">پس‌زمینه سفید، بدون عینک آفتابی، صورت کامل رو به دوربین.</div>
        </div>

        <!-- بلیط رفت و برگشت -->
        <div class="doc-group">
            <h3>
                بلیط رفت و برگشت
                <small>الزامی</small>
            </h3>
            <input type="file" name="ticket" accept=".jpg,.jpeg,.png,.pdf">
            <?php if (!empty($errors['ticket'])): ?>
                <div class="error"><?= htmlspecialchars($errors['ticket']) ?></div>
            <?php endif; ?>
            <div class="helper">رزرو یا بلیط نهایی، حتماً تاریخ‌ها قابل مشاهده باشند.</div>
        </div>

        <!-- رزرو هتل -->
        <div class="doc-group">
            <h3>
                واچر / رزرو هتل
                <small>الزامی</small>
            </h3>
            <input type="file" name="hotel" accept=".jpg,.jpeg,.png,.pdf">
            <?php if (!empty($errors['hotel'])): ?>
                <div class="error"><?= htmlspecialchars($errors['hotel']) ?></div>
            <?php endif; ?>
            <div class="helper">نام مسافر و تاریخ اقامت در هتل باید مشخص باشد.</div>
        </div>

        <!-- تمکن مالی -->
        <div class="doc-group">
            <h3>
                پرینت گردش حساب / تمکن مالی
                <small>الزامی</small>
            </h3>
            <input type="file" name="bank" accept=".jpg,.jpeg,.png,.pdf">
            <?php if (!empty($errors['bank'])): ?>
                <div class="error"><?= htmlspecialchars($errors['bank']) ?></div>
            <?php endif; ?>
            <div class="helper">ترجیحاً پرینت مهرشده سه ماه آخر، readable باشد.</div>
        </div>

        <!-- دعوت‌نامه (اختیاری) -->
        <div class="doc-group">
            <h3>
                دعوت‌نامه (در صورت وجود)
                <small>اختیاری</small>
            </h3>
            <input type="file" name="invitation" accept=".jpg,.jpeg,.png,.pdf">
            <?php if (!empty($errors['invitation'])): ?>
                <div class="error"><?= htmlspecialchars($errors['invitation']) ?></div>
            <?php endif; ?>
            <div class="helper">برای ویزای تجاری یا خانوادگی توصیه می‌شود.</div>
        </div>

        <div class="btn-row">
            <a href="china_step3.php">
                <button type="button" class="btn-back">← بازگشت به مرحله قبل</button>
            </a>
            <button type="submit" class="btn-next">ذخیره و ادامه</button>
        </div>
    </form>
</div>

</body>
</html>
