<?php
// public/china_step5.php
session_start();
require_once __DIR__ . '/../config/db.php';

if (empty($_SESSION['china_application_id'])) {
    header('Location: china_step1.php');
    exit;
}

// CSRF
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$success = $_SESSION['success_message'] ?? null;
$errors  = $_SESSION['form_errors'] ?? [];

unset($_SESSION['success_message'], $_SESSION['form_errors']);

$applicationId = $_SESSION['china_application_id'];
$pdo = get_pdo();

// گرفتن داده‌ها
// درخواست
$stmt = $pdo->prepare("SELECT * FROM visa_applications WHERE id = ?");
$stmt->execute([$applicationId]);
$app = $stmt->fetch();

if (!$app) {
    die('Application not found.');
}

// متقاضی
$stmt = $pdo->prepare("SELECT * FROM visa_applicants WHERE application_id = ?");
$stmt->execute([$applicationId]);
$applicant = $stmt->fetch();

// پاسپورت
$stmt = $pdo->prepare("SELECT * FROM visa_passports WHERE application_id = ?");
$stmt->execute([$applicationId]);
$passport = $stmt->fetch();

// سفر
$stmt = $pdo->prepare("SELECT * FROM visa_travels WHERE application_id = ?");
$stmt->execute([$applicationId]);
$travel = $stmt->fetch();

// مدارک
$stmt = $pdo->prepare("SELECT * FROM visa_documents WHERE application_id = ? ORDER BY doc_type");
$stmt->execute([$applicationId]);
$documents = $stmt->fetchAll();

function e($v) {
    return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مرحله ۵ - مرور و ثبت نهایی ویزای چین</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <style>
        body { font-family:sans-serif; background:#f5f7fb; margin:0; padding:0; }
        .container {
            max-width:900px; margin:40px auto; background:#fff;
            border-radius:12px; padding:24px 28px;
            box-shadow:0 6px 18px rgba(0,0,0,0.08);
        }
        h1 { font-size:22px; margin-bottom:6px; text-align:right;}
        .subtitle { font-size:13px; color:#666; margin-bottom:20px; text-align:right;}
        .badge-country {
            display:inline-block; background:#eaf1ff; color:#1b46c2;
            padding:4px 10px; border-radius:999px; font-size:11px; margin-bottom:10px;
        }
        .section {
            border:1px solid #e0e4ef; border-radius:10px;
            padding:14px 16px; margin-bottom:16px; background:#fafbff;
        }
        .section h2 {
            margin:0 0 10px 0; font-size:16px; display:flex;
            justify-content:space-between; align-items:center;
        }
        .section h2 span.small {
            font-size:11px; color:#777;
        }
        table {
            width:100%; border-collapse:collapse;
            font-size:13px;
        }
        td {
            padding:4px 6px;
            border-bottom:1px solid #e5e8f0;
        }
        td.label {
            width:30%; font-weight:bold; color:#333;
        }
        .doc-list {
            list-style:none; padding:0; margin:0;
        }
        .doc-list li {
            padding:4px 0;
            border-bottom:1px dashed #dde2f0;
            font-size:13px;
        }
        .doc-type {
            font-weight:bold;
        }
        .status-pill {
            display:inline-block; padding:2px 8px; border-radius:999px;
            font-size:11px; margin-right:6px;
        }
        .status-draft {
            background:#fff4e5; color:#b25b00;
            border:1px solid #f0c78a;
        }
        .status-submitted {
            background:#e6ffed; color:#146c2e;
            border:1px solid #9be7b0;
        }

        .global-success {
            background:#e6ffed; border:1px solid #9be7b0; color:#146c2e;
            padding:10px 12px; border-radius:8px; font-size:12px; margin-bottom:14px;
        }
        .global-error {
            background:#ffe5e5; border:1px solid #f5b5b5; color:#a30000;
            padding:10px 12px; border-radius:8px; font-size:12px; margin-bottom:14px;
        }

        .confirm-box {
            margin-top:16px; font-size:13px; color:#333;
        }
        .confirm-box label {
            display:flex; align-items:flex-start; gap:8px; cursor:pointer;
        }
        .confirm-box input[type="checkbox"] {
            margin-top:3px;
        }
        .btn-row { display:flex; justify-content:space-between; margin-top:18px;}
        button {
            border:none; padding:9px 18px; border-radius:8px;
            font-size:13px; cursor:pointer;
        }
        .btn-back { background:#e0e4ef; color:#333; }
        .btn-submit { background:#0f9d58; color:#fff; }
        .btn-submit:hover { background:#0b7a44;}
        @media (max-width:600px){
            .container { margin:16px; padding:18px; }
            td.label { width:40%; }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="badge-country">🇨🇳 فرم ویزای چین - مرحله ۵ از ۶</div>
    <h1>مرور نهایی اطلاعات</h1>
    <div class="subtitle">
        لطفاً اطلاعات زیر را بررسی کنید. در صورت نیاز می‌توانید به مراحل قبل برگردید و ویرایش کنید.
        پس از ثبت نهایی، ویرایش آنلاین امکان‌پذیر نخواهد بود.
    </div>

    <?php if ($success): ?>
        <div class="global-success"><?= e($success) ?></div>
    <?php endif; ?>

    <?php if (!empty($errors['confirm'])): ?>
        <div class="global-error"><?= e($errors['confirm']) ?></div>
    <?php endif; ?>

    <!-- وضعیت پرونده -->
    <div class="section">
        <h2>
            وضعیت پرونده
            <span class="small">Application Status</span>
        </h2>
        <p style="font-size:13px;">
            وضعیت فعلی:
            <?php if ($app['status'] === 'submitted'): ?>
                <span class="status-pill status-submitted">ثبت شده (Submitted)</span>
            <?php else: ?>
                <span class="status-pill status-draft">در حال تکمیل (Draft)</span>
            <?php endif; ?>
        </p>
    </div>

    <!-- اطلاعات شخصی -->
    <div class="section">
        <h2>اطلاعات شخصی <span class="small">Applicant Info</span></h2>
        <?php if ($applicant): ?>
            <table>
                <tr>
                    <td class="label">نام و نام خانوادگی (لاتین)</td>
                    <td><?= e($applicant['given_name'] . ' ' . $applicant['family_name']) ?></td>
                </tr>
                <tr>
                    <td class="label">جنسیت</td>
                    <td><?= $applicant['gender'] === 'male' ? 'Male' : 'Female' ?></td>
                </tr>
                <tr>
                    <td class="label">تاریخ تولد</td>
                    <td><?= e($applicant['dob']) ?></td>
                </tr>
                <tr>
                    <td class="label">ملیت</td>
                    <td><?= e($applicant['nationality']) ?></td>
                </tr>
                <tr>
                    <td class="label">کشور محل تولد</td>
                    <td><?= e($applicant['birth_country']) ?></td>
                </tr>
                <tr>
                    <td class="label">وضعیت تأهل</td>
                    <td><?= e($applicant['marital_status']) ?></td>
                </tr>
                <tr>
                    <td class="label">موبایل</td>
                    <td><?= e($applicant['phone']) ?></td>
                </tr>
                <tr>
                    <td class="label">ایمیل</td>
                    <td><?= e($applicant['email']) ?></td>
                </tr>
            </table>
        <?php else: ?>
            <p style="font-size:13px;color:#a00;">اطلاعات متقاضی یافت نشد.</p>
        <?php endif; ?>
    </div>

    <!-- پاسپورت -->
    <div class="section">
        <h2>اطلاعات پاسپورت <span class="small">Passport Info</span></h2>
        <?php if ($passport): ?>
            <table>
                <tr>
                    <td class="label">شماره پاسپورت</td>
                    <td><?= e($passport['passport_number']) ?></td>
                </tr>
                <tr>
                    <td class="label">محل صدور</td>
                    <td><?= e($passport['place_of_issue']) ?></td>
                </tr>
                <tr>
                    <td class="label">تاریخ صدور</td>
                    <td><?= e($passport['date_of_issue']) ?></td>
                </tr>
                <tr>
                    <td class="label">تاریخ انقضاء</td>
                    <td><?= e($passport['date_of_expiry']) ?></td>
                </tr>
            </table>
        <?php else: ?>
            <p style="font-size:13px;color:#a00;">اطلاعات پاسپورت ثبت نشده است.</p>
        <?php endif; ?>
    </div>

    <!-- سفر -->
    <div class="section">
        <h2>اطلاعات سفر <span class="small">Travel Info</span></h2>
        <?php if ($travel): ?>
            <table>
                <tr>
                    <td class="label">نوع ویزا</td>
                    <td><?= e($travel['visa_type']) ?></td>
                </tr>
                <tr>
                    <td class="label">هدف سفر</td>
                    <td><?= e($travel['purpose_of_visit']) ?></td>
                </tr>
                <tr>
                    <td class="label">تاریخ ورود</td>
                    <td><?= e($travel['entry_date']) ?></td>
                </tr>
                <tr>
                    <td class="label">تاریخ خروج</td>
                    <td><?= e($travel['exit_date']) ?></td>
                </tr>
                <tr>
                    <td class="label">مدت اقامت (روز)</td>
                    <td><?= e($travel['duration_days']) ?></td>
                </tr>
                <tr>
                    <td class="label">اولین شهر/فرودگاه ورود</td>
                    <td><?= e($travel['port_of_entry']) ?></td>
                </tr>
                <tr>
                    <td class="label">سفر قبلی به چین</td>
                    <td><?= $travel['previous_china_visit'] ? 'بله' : 'خیر' ?></td>
                </tr>
                <?php if ($travel['previous_china_visit'] && !empty($travel['previous_visa_details'])): ?>
                    <tr>
                        <td class="label">جزئیات سفر/ویزای قبلی</td>
                        <td><?= nl2br(e($travel['previous_visa_details'])) ?></td>
                    </tr>
                <?php endif; ?>
            </table>
        <?php else: ?>
            <p style="font-size:13px;color:#a00;">اطلاعات سفر ثبت نشده است.</p>
        <?php endif; ?>
    </div>

    <!-- مدارک -->
    <div class="section">
        <h2>مدارک بارگذاری‌شده <span class="small">Uploaded Documents</span></h2>
        <?php if ($documents): ?>
            <ul class="doc-list">
                <?php foreach ($documents as $doc): ?>
                    <li>
                        <span class="doc-type"><?= e($doc['doc_type']) ?></span>
                        —
                        <span><?= e($doc['original_name']) ?></span>
                        <span style="font-size:11px;color:#777;">
                            (<?= e($doc['mime_type']) ?>)
                        </span>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <p style="font-size:13px;color:#a00;">هیچ مدرکی ثبت نشده است.</p>
        <?php endif; ?>
        <p class="helper" style="font-size:11px;color:#888;margin-top:6px;">
            * فایل‌ها در سرور با واترمارک اختصاصی ذخیره شده‌اند و صرفاً برای بررسی کارشناسان استفاده می‌شوند.
        </p>
    </div>

    <!-- فرم تأیید نهایی -->
    <form method="post" action="china_step5_submit.php">
        <input type="hidden" name="csrf_token" value="<?= e($_SESSION['csrf_token']) ?>">

        <div class="confirm-box">
            <label>
                <input type="checkbox" name="confirm" value="1">
                <span>
                    تمامی اطلاعات فوق را با دقت بررسی کرده‌ام و تأیید می‌کنم که
                    مطابق واقعیت و منطبق با مدارک ارائه‌شده است. می‌دانم که ارائه
                    اطلاعات نادرست می‌تواند منجر به رد ویزا شود.
                </span>
            </label>
        </div>

        <div class="btn-row">
            <a href="china_step4.php">
                <button type="button" class="btn-back">← بازگشت به آپلود مدارک</button>
            </a>
            <button type="submit" class="btn-submit">
                ثبت نهایی درخواست ویزا
            </button>
        </div>
    </form>

</div>

</body>
</html>
