<?php
// public/china_step6.php
session_start();
require_once __DIR__ . '/../config/db.php';

if (empty($_SESSION['china_application_id'])) {
    header('Location: china_step1.php');
    exit;
}

$applicationId = $_SESSION['china_application_id'];
$pdo = get_pdo();

// گرفتن درخواست
$stmt = $pdo->prepare("SELECT * FROM visa_applications WHERE id = ?");
$stmt->execute([$applicationId]);
$app = $stmt->fetch();

if (!$app) {
    die('Application not found.');
}

// فقط اگر submitted شده اجازه مرحله ۶ بدیم
if ($app['status'] !== 'submitted' && $app['status'] !== 'appointment_booked') {
    // اگر هنوز نرسیده به submit برگرد مرحله ۵
    header('Location: china_step5.php');
    exit;
}

// CSRF
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$success = $_SESSION['success_message'] ?? null;
$errors  = $_SESSION['form_errors'] ?? [];
unset($_SESSION['success_message'], $_SESSION['form_errors']);

// اگر قبلاً نوبت گرفته شده باشد
$stmt = $pdo->prepare("SELECT * FROM visa_appointments WHERE application_id = ?");
$stmt->execute([$applicationId]);
$appointment = $stmt->fetch();

function e($v) {
    return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}

// مراکز پیشنهادی (می‌تونی بعداً از DB یا تنظیمات بخونی)
$centers = [
    'tehran_vac'   => 'مرکز تحویل مدارک تهران',
    'istanbul_vac' => 'مرکز تحویل مدارک استانبول',
    'dubai_vac'    => 'مرکز تحویل مدارک دبی',
];

$timeSlots = [
    '09:00-10:00',
    '10:00-11:00',
    '11:00-12:00',
    '13:00-14:00',
    '14:00-15:00',
];
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مرحله ۶ - رزرو وقت و پرداخت ویزای چین</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <style>
        body { font-family:sans-serif; background:#f5f7fb; margin:0; padding:0; }
        .container {
            max-width:720px; margin:40px auto; background:#fff;
            border-radius:12px; padding:24px 28px;
            box-shadow:0 6px 18px rgba(0,0,0,0.08);
        }
        h1 { font-size:22px; margin-bottom:6px; text-align:right;}
        .subtitle { font-size:13px; color:#666; margin-bottom:20px; text-align:right;}
        .badge-country {
            display:inline-block; background:#eaf1ff; color:#1b46c2;
            padding:4px 10px; border-radius:999px; font-size:11px; margin-bottom:10px;
        }
        .global-success {
            background:#e6ffed; border:1px solid #9be7b0; color:#146c2e;
            padding:10px 12px; border-radius:8px; font-size:12px; margin-bottom:14px;
        }
        .global-error {
            background:#ffe5e5; border:1px solid #f5b5b5; color:#a30000;
            padding:10px 12px; border-radius:8px; font-size:12px; margin-bottom:14px;
        }
        .section {
            border:1px solid #e0e4ef; border-radius:10px;
            padding:14px 16px; margin-bottom:16px; background:#fafbff;
        }
        .section h2 { margin:0 0 10px 0; font-size:16px;}
        .status-pill {
            display:inline-block; padding:2px 8px; border-radius:999px;
            font-size:11px; margin-right:6px;
        }
        .status-submitted {
            background:#e6f1ff; color:#1347b0; border:1px solid #aac5ff;
        }
        .status-booked {
            background:#e6ffed; color:#146c2e; border:1px solid #9be7b0;
        }

        .form-group { margin-bottom:14px; display:flex; flex-direction:column; }
        label { font-size:13px; margin-bottom:4px; color:#333; }
        label span.en { font-size:11px; color:#777; }
        input[type="date"], select {
            padding:8px 10px; font-size:13px; border:1px solid #ccd2e0;
            border-radius:6px; outline:none;
        }
        select { direction:ltr; }
        input:focus, select:focus {
            border-color:#3563e9; box-shadow:0 0 0 2px rgba(53,99,233,0.15);
        }
        .error { color:#d93025; font-size:11px; margin-top:3px; }
        .helper { font-size:11px; color:#888; margin-top:2px; }

        .btn-row { display:flex; justify-content:space-between; margin-top:18px; }
        button {
            border:none; padding:9px 18px; border-radius:8px;
            font-size:13px; cursor:pointer;
        }
        .btn-back { background:#e0e4ef; color:#333; }
        .btn-submit { background:#0f9d58; color:#fff; }
        .btn-submit:hover { background:#0b7a44;}

        @media (max-width:600px){
            .container { margin:16px; padding:18px; }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="badge-country">🇨🇳 فرم ویزای چین - مرحله ۶ از ۶</div>
    <h1>رزرو وقت تحویل مدارک و پرداخت</h1>
    <div class="subtitle">
        لطفاً مرکز تحویل مدارک، تاریخ مراجعه و بازه زمانی را انتخاب کنید.
        پرداخت می‌تواند در محل یا آنلاین (در آینده) انجام شود.
    </div>

    <?php if ($success): ?>
        <div class="global-success"><?= e($success) ?></div>
    <?php endif; ?>

    <?php if (!empty($errors)): ?>
        <div class="global-error">لطفاً خطاهای مشخص‌شده را اصلاح کنید.</div>
    <?php endif; ?>

    <div class="section">
        <h2>وضعیت پرونده</h2>
        <p style="font-size:13px;">
            کد پرونده: <strong>#<?= e($applicationId) ?></strong><br>
            وضعیت فعلی:
            <?php if ($app['status'] === 'appointment_booked'): ?>
                <span class="status-pill status-booked">نوبت رزرو شده (Appointment Booked)</span>
            <?php else: ?>
                <span class="status-pill status-submitted">ثبت شده (Submitted)</span>
            <?php endif; ?>
        </p>
        <?php if ($appointment): ?>
            <p style="font-size:13px;margin-top:6px;">
                نوبت فعلی شما:
                <strong><?= e($centers[$appointment['center']] ?? $appointment['center']) ?></strong>،
                تاریخ <strong><?= e($appointment['appointment_date']) ?></strong>،
                ساعت <strong><?= e($appointment['time_slot']) ?></strong>
                — وضعیت پرداخت:
                <strong><?= e($appointment['payment_status']) ?></strong>
            </p>
        <?php endif; ?>
    </div>

    <form method="post" action="china_step6_submit.php" novalidate>
        <input type="hidden" name="csrf_token" value="<?= e($_SESSION['csrf_token']) ?>">

        <div class="section">
            <h2>انتخاب مرکز و زمان مراجعه</h2>

            <div class="form-group">
                <label>مرکز تحویل مدارک</label>
                <select name="center">
                    <option value="">انتخاب کنید</option>
                    <?php foreach ($centers as $key => $label): ?>
                        <option value="<?= e($key) ?>"
                            <?= (!empty($_POST['center']) && $_POST['center'] === $key) ? 'selected' : '' ?>>
                            <?= e($label) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <?php if (!empty($errors['center'])): ?>
                    <div class="error"><?= e($errors['center']) ?></div>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label>تاریخ مراجعه</label>
                <input type="date" name="appointment_date"
                       value="<?= !empty($_POST['appointment_date']) ? e($_POST['appointment_date']) : '' ?>">
                <?php if (!empty($errors['appointment_date'])): ?>
                    <div class="error"><?= e($errors['appointment_date']) ?></div>
                <?php endif; ?>
                <div class="helper">حداقل از فردا به بعد انتخاب شود.</div>
            </div>

            <div class="form-group">
                <label>بازه زمانی مراجعه</label>
                <select name="time_slot">
                    <option value="">انتخاب کنید</option>
                    <?php foreach ($timeSlots as $slot): ?>
                        <option value="<?= e($slot) ?>"
                            <?= (!empty($_POST['time_slot']) && $_POST['time_slot'] === $slot) ? 'selected' : '' ?>>
                            <?= e($slot) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <?php if (!empty($errors['time_slot'])): ?>
                    <div class="error"><?= e($errors['time_slot']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="section">
            <h2>روش پرداخت</h2>
            <div class="form-group">
                <label>روش پرداخت کارمزد سرویس</label>
                <select name="payment_method">
                    <option value="">انتخاب کنید</option>
                    <option value="pay_at_center"
                        <?= (!empty($_POST['payment_method']) && $_POST['payment_method']==='pay_at_center') ? 'selected' : '' ?>>
                        پرداخت در مرکز (کارت یا نقد)
                    </option>
                    <option value="online_later"
                        <?= (!empty($_POST['payment_method']) && $_POST['payment_method']==='online_later') ? 'selected' : '' ?>>
                        پرداخت آنلاین بعدی (لینک برای شما ارسال می‌شود)
                    </option>
                </select>
                <?php if (!empty($errors['payment_method'])): ?>
                    <div class="error"><?= e($errors['payment_method']) ?></div>
                <?php endif; ?>
                <div class="helper">
                    در شروع کار می‌تونیم فقط «پرداخت در مرکز» را فعال نگه داریم؛
                    بعداً درگاه آنلاین را اضافه می‌کنیم.
                </div>
            </div>
        </div>

        <div class="btn-row">
            <a href="china_step5.php">
                <button type="button" class="btn-back">← بازگشت به مرور اطلاعات</button>
            </a>
            <button type="submit" class="btn-submit">
                ثبت / بروزرسانی نوبت
            </button>
        </div>
    </form>

</div>

</body>
</html>
