<?php
// public/china_step6_submit.php
session_start();
require_once __DIR__ . '/../config/db.php';

if (empty($_SESSION['china_application_id'])) {
    header('Location: china_step1.php');
    exit;
}

// CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token'] ?? '')) {
    die('Invalid CSRF token');
}

$applicationId = $_SESSION['china_application_id'];
$pdo = get_pdo();

// چک وضعیت درخواست
$stmt = $pdo->prepare("SELECT * FROM visa_applications WHERE id = ?");
$stmt->execute([$applicationId]);
$app = $stmt->fetch();

if (!$app) {
    die('Application not found.');
}
if ($app['status'] !== 'submitted' && $app['status'] !== 'appointment_booked') {
    header('Location: china_step5.php');
    exit;
}

$errors = [];

// گرفتن فیلدها
$center          = trim($_POST['center'] ?? '');
$appointmentDate = trim($_POST['appointment_date'] ?? '');
$timeSlot        = trim($_POST['time_slot'] ?? '');
$paymentMethod   = trim($_POST['payment_method'] ?? '');

// اعتبارسنجی مرکز
$validCenters = ['tehran_vac','istanbul_vac','dubai_vac'];
if ($center === '' || !in_array($center, $validCenters, true)) {
    $errors['center'] = 'لطفاً مرکز تحویل مدارک را انتخاب کنید.';
}

// اعتبارسنجی تاریخ
if ($appointmentDate === '') {
    $errors['appointment_date'] = 'تاریخ مراجعه الزامی است.';
} else {
    $d = DateTime::createFromFormat('Y-m-d', $appointmentDate);
    $err = DateTime::getLastErrors();
    if ($d === false || $err['warning_count'] > 0 || $err['error_count'] > 0) {
        $errors['appointment_date'] = 'تاریخ مراجعه نامعتبر است.';
    } else {
        $today = new DateTime('today');
        $min   = (clone $today)->modify('+1 day');  // حداقل فردا
        if ($d < $min) {
            $errors['appointment_date'] = 'حداقل از فردا به بعد قابل رزرو است.';
        }
    }
}

// بازه زمانی
$validSlots = ['09:00-10:00','10:00-11:00','11:00-12:00','13:00-14:00','14:00-15:00'];
if ($timeSlot === '' || !in_array($timeSlot, $validSlots, true)) {
    $errors['time_slot'] = 'بازه زمانی مراجعه را انتخاب کنید.';
}

// روش پرداخت
$validPayments = ['pay_at_center','online_later'];
if ($paymentMethod === '' || !in_array($paymentMethod, $validPayments, true)) {
    $errors['payment_method'] = 'روش پرداخت را انتخاب کنید.';
}

// اگر خطا داریم
if ($errors) {
    $_SESSION['form_errors'] = $errors;
    header('Location: china_step6.php');
    exit;
}

// ذخیره در DB
$pdo->beginTransaction();

try {
    // آیا قبلاً نوبت وجود دارد؟
    $stmt = $pdo->prepare("SELECT id FROM visa_appointments WHERE application_id = ?");
    $stmt->execute([$applicationId]);
    $existingId = $stmt->fetchColumn();

    $paymentStatus = 'unpaid';   // فعلاً همه unpaid

    if ($existingId) {
        $stmt = $pdo->prepare("
            UPDATE visa_appointments
            SET center = ?, appointment_date = ?, time_slot = ?, 
                payment_method = ?, payment_status = ?, updated_at = NOW()
            WHERE id = ?
        ");
        $stmt->execute([
            $center,
            $appointmentDate,
            $timeSlot,
            $paymentMethod,
            $paymentStatus,
            $existingId
        ]);
    } else {
        $stmt = $pdo->prepare("
            INSERT INTO visa_appointments
                (application_id, center, appointment_date, time_slot,
                 payment_method, payment_status, created_at, updated_at)
            VALUES (?,?,?,?,?,?,NOW(),NOW())
        ");
        $stmt->execute([
            $applicationId,
            $center,
            $appointmentDate,
            $timeSlot,
            $paymentMethod,
            $paymentStatus,
        ]);
    }

    // آپدیت وضعیت پرونده
    $stmt = $pdo->prepare("
        UPDATE visa_applications
        SET status = 'appointment_booked',
            current_step = 6,
            updated_at = NOW()
        WHERE id = ?
    ");
    $stmt->execute([$applicationId]);

    $pdo->commit();
} catch (Exception $e) {
    $pdo->rollBack();
    die('DB Error: '.$e->getMessage());
}

$_SESSION['success_message'] = 'نوبت شما با موفقیت ثبت شد. لطفاً در زمان انتخاب‌شده با مدارک کامل مراجعه کنید.';
header('Location: china_step6.php');
exit;
